<?php
/**
 * Init Class
 * 
 * @package simple-store-maps
 * @author codetot
 * @since 0.0.1
 */

class Simple_Store_Maps_Init {
    public function __construct()
    {
    
        add_action('init', [$this, 'load_translations']);

        add_action('init', [$this, 'register_shortcodes']);
        add_action('wp_enqueue_scripts', [$this, 'register_frontend_assets']);

        add_filter( 'script_loader_tag', [$this, 'defer_scripts'], 10, 2 );
    }

    function load_translations() {
        load_plugin_textdomain( 'simple-store-maps', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
    }

    function register_shortcodes() {
        add_shortcode('simple_store_maps', [$this, 'render_shortcode']);
    }

    function render_shortcode() {
        $map_svg_icon = '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 11a3 3 0 1 0 6 0a3 3 0 0 0 -6 0" /><path d="M17.657 16.657l-4.243 4.243a2 2 0 0 1 -2.827 0l-4.244 -4.243a8 8 0 1 1 11.314 0z" /></svg>';
        $phone_svg_icon = '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 4h4l2 5l-2.5 1.5a11 11 0 0 0 5 5l1.5 -2.5l5 2v4a2 2 0 0 1 -2 2a16 16 0 0 1 -15 -15a2 2 0 0 1 2 -2" /></svg>';
        $email_svg_icon = '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 7a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-10z" /><path d="M3 7l9 6l9 -6" /></svg>';
        $svg_icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M9 6l6 6l-6 6"></path></svg>';

        ob_start();
        ?>
        <div class="simple-store-maps" x-data="simpleStoreMapsData">
            <div class="simple-store-maps__sidebar">
                <div class="simple-store-maps__list">
                    <template x-for="(map, index) in maps">
                        <div class="simple-store-maps__item" x-bind:class="activeIndex === index ? ' is-active' : ''">
                            <button class="simple-store-maps__item-button" @click="activeIndex = index">
                                <span class="simple-store-maps__item-text" x-html="map.title"></span>
                                <span class="simple-store-maps__item-icon" aria-hidden="true"><?php echo $svg_icon; // phpcs:ignore ?></span>
                            </button>
                            <div class="simple-store-maps__content" x-show="activeIndex === index" x-transition>
                                <ul class="simple-store-maps__item-list">
                                    <template x-if="map.address">
                                        <li class="simple-store-maps__item-row">
                                            <span class="simple-store-maps__item-icon" aria-hidden="true"><?php echo $map_svg_icon; // phpcs:ignore ?></span>
                                            <span class="simple-store-maps__item-content">
                                                <span class="simple-store-maps__item-label"><?php esc_html_e('Address', 'simple-store-maps'); ?></span>
                                                <template x-if="map.google_map_url">
                                                    <a class="simple-store-maps__link" target="_blank" rel="nofollow" :href="map.google_map_url" x-text="map.address"></a>
                                                </template>
                                                <template x-if="! map.google_map_url">
                                                    <span x-text="map.address"></span>
                                                </template>
                                            </span>
                                        </li>
                                    </template>
                                    <template x-if="map.phone && map.phone_url">
                                        <li class="simple-store-maps__item-row">
                                            <span class="simple-store-maps__item-icon" aria-hidden="true"><?php echo $phone_svg_icon; // phpcs:ignore ?></span>
                                            <span class="simple-store-maps__item-content">
                                                <span class="simple-store-maps__item-label"><?php esc_html_e('Phone', 'simple-store-maps'); ?></span>
                                                <a class="simple-store-maps__link" target="_blank" rel="nofollow" :href="map.phone_url" x-text="map.phone"></a>
                                            </span>
                                        </li>
                                    </template>
                                    <template x-if="map.email && map.email_url">
                                        <li class="simple-store-maps__item-row">
                                            <span class="simple-store-maps__item-icon" aria-hidden="true"><?php echo $email_svg_icon; // phpcs:ignore ?></span>
                                            <span class="simple-store-maps__item-content">
                                                <span class="simple-store-maps__item-label"><?php esc_html_e('Email', 'simple-store-maps'); ?></span>
                                                <a class="simple-store-maps__link" target="_blank" rel="nofollow" :href="map.email_url" x-text="map.email"></a>
                                            </span>
                                        </li>
                                    </template>
                                </ul>
                            </div>
                        </div>
                    </template>
                </div>
            </div>
            <div class="simple-store-maps__maps">
                <template x-for="(map, index) in maps">
                    <div class="simple-store-maps__map" x-show="activeIndex === index">
                        <iframe class="simple-store-maps__map-iframe" width="800" height="600" x-bind:src="map.google_maps_embed" loading="lazy"></iframe>
                    </div>
                </template>
            </div>
        </div>
        
        <?php
        return ob_get_clean();
    }

    function register_frontend_assets() {
        $is_visible = apply_filters('ssm_is_visible', '__return_true');

        if ( !$is_visible ) return;

        wp_enqueue_script('alpine', SSM_URI . '/assets/alpine.min.js', [], '3.14.0', false);
        wp_enqueue_style('simple-store-maps', SSM_URI . '/assets/frontend.min.css', [], SSM_VERSION, false);
        wp_enqueue_script('simple-store-maps', SSM_URI . '/assets/frontend.min.js', ['alpine'], SSM_VERSION, false);
    }

    function defer_scripts( $tag, $handle ) {
        if ( 'alpine' !== $handle ) return $tag;  
    
        return str_replace( ' src', ' defer src', $tag );
    }
}

new Simple_Store_Maps_Init();