<?php
function child_theme_enqueue_styles() {
    wp_enqueue_style('custom-fonts', get_stylesheet_directory_uri() . '/fonts/BalooBhai-Regular.ttf', array(), null);
}
add_action('wp_enqueue_scripts', 'child_theme_enqueue_styles');

// Nhúng css
function tcwp_styles() {
    wp_register_style( 'tc-style', get_stylesheet_directory_uri() . '/css-tiencuong.css', array(), '1.0.0', 'all' );
    wp_enqueue_style( 'tc-style' );
}
add_action( 'wp_enqueue_scripts', 'tcwp_styles' );

// Thêm Font Awesome 6.2.1 vào theme
function tcwp_load_fa() {
	wp_enqueue_style( 'puramu-fa', get_stylesheet_directory_uri() . '/fontawesome/css/all.min.css' );
}
add_action( 'wp_enqueue_scripts', 'tcwp_load_fa' );

// Nên thêm vào flatsome

// Ho tro upload anh svg len website wordpress
function add_file_types_to_uploads($file_types){
    $new_filetypes = array();
    $new_filetypes['svg'] = 'image/svg';
    $file_types = array_merge($file_types, $new_filetypes );
    return $file_types; 
} 
add_action('upload_mimes', 'add_file_types_to_uploads');

// xoá thông báo Flatsome issues
add_action( 'init', 'hide_notice' );
function hide_notice() {
remove_action( 'admin_notices', 'flatsome_maintenance_admin_notice' );
}
// bộ lọc ngăn crop hình ảnh tải lên
function tcwp_tat_crop( $enable, $orig_w, $orig_h, $dest_w, $dest_h, $crop )
{
return false;
}
add_filter( 'image_resize_dimensions', 'tcwp_tat_crop', 10, 6 );
function tcwp_tat_image_sizes() {
foreach ( get_intermediate_image_sizes() as $size ) {
remove_image_size( $size );
}
}
add_action( 'init', 'tcwp_tat_image_sizes' );
//Remove <p> and <br> from Contact Form 7
add_filter('wpcf7_autop_or_not', '__return_false');
// Xóa bài viết sẽ xóa luôn hình ảnh đính kèm
add_action( 'before_delete_post', 'delete_all_attached_media' );
function delete_all_attached_media( $post_id ) {
if( get_post_type($post_id) == "post" ) {
$attachments = get_attached_media( '', $post_id );
foreach ($attachments as $attachment) {
wp_delete_attachment( $attachment->ID, 'true' );
}
}
}

//* tải điều kiện js và css woocommerce
function tcwp_load_woc_js_css() {
     if (function_exists('is_woocommerce')) {
           if (!is_woocommerce() && !is_cart() && !is_checkout() && !is_account_page() && !is_product() && !is_product_category() && !is_shop()) {
                wp_dequeue_style('woocommerce-general');
            wp_dequeue_style('woocommerce-layout');
            wp_dequeue_style('woocommerce-smallscreen');
            wp_dequeue_style('woocommerce_frontend_styles');
            wp_dequeue_style('woocommerce_fancybox_styles');
            wp_dequeue_style('woocommerce_chosen_styles');
            wp_dequeue_style('woocommerce_prettyPhoto_css');
            wp_dequeue_script('wc_price_slider');
            wp_dequeue_script('wc-single-product');
            wp_dequeue_script('wc-add-to-cart');
            wp_dequeue_script('wc-checkout');
            wp_dequeue_script('wc-add-to-cart-variation');
            wp_dequeue_script('wc-single-product');
            wp_dequeue_script('wc-cart');
            wp_dequeue_script('wc-chosen');
            wp_dequeue_script('woocommerce');
            wp_dequeue_script('prettyPhoto');
            wp_dequeue_script('prettyPhoto-init');
            wp_dequeue_script('jquery-blockui');
            wp_dequeue_script('jquery-placeholder');
            wp_dequeue_script('fancybox');
            wp_dequeue_script('jqueryui');
             }
      }
}
add_action('wp_enqueue_scripts', 'tcwp_load_woc_js_css');

// Xóa classic-theme
add_action('wp_enqueue_scripts','wptangtoc_disable_classic_theme_styles', 100);
function wptangtoc_disable_classic_theme_styles(){
wp_deregister_style('classic-theme-styles');
wp_dequeue_style('classic-theme-styles');
}

// Đổi chữ add to cart trong trang chi tiết
add_filter( 'woocommerce_product_single_add_to_cart_text', 'woocommerce_custom_single_add_to_cart_text' ); 
function woocommerce_custom_single_add_to_cart_text() {
    return __( 'MUA NGAY', 'woocommerce' ); 
}
// Đổi chữ add to cart ở các trang
add_filter( 'woocommerce_product_add_to_cart_text', 'woocommerce_custom_product_add_to_cart_text' );  
function woocommerce_custom_product_add_to_cart_text() {
    return __( 'MUA NGAY', 'woocommerce' );
}

// Chuyển đ sang VNĐ
add_filter('woocommerce_currency_symbol', 'change_existing_currency_symbol', 10, 2);
function change_existing_currency_symbol( $currency_symbol, $currency ) {
 switch( $currency ) {
 case 'VND': $currency_symbol = 'VNĐ'; break;
 }
 return $currency_symbol;
}


//Tự động hoàn tất đơn hàng
add_action('woocommerce_order_status_changed', 'tiencuong', 9999, 4);
function tiencuong($order_id, $from, $to, $o)
{
    if ( ! $order_id ) {
        return;
    }
    global $product;
    $order = wc_get_order( $order_id );
    if ($order->data['status'] == 'onhold' ) {
        $payment_method=$order->get_payment_method();
        if ($payment_method!="paypal")  //cod
        {
            $order->update_status( 'completed' );
        }
    }
}

//CODE LAY LUOT XEM
function getPostViews($postID){
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return "01 lượt xem";
    }
    return $count.' lượt xem';
}
 
// CODE DEM LUOT XEM

function setPostViews($postID) {
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    }else{
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}

//CODE HIEN THI SO LUOT XEM BAI VIET TRONG DASHBOARDH

add_filter('manage_posts_columns', 'posts_column_views');
add_action('manage_posts_custom_column', 'posts_custom_column_views',5,2);
function posts_column_views($defaults){
    $defaults['post_views'] = __('Lượt xem');
    return $defaults;
}
function posts_custom_column_views($column_name, $id){
    if($column_name === 'post_views'){
        echo getPostViews(get_the_ID());
    }
}

// Làm sạch header
remove_action('wp_head', 'wp_generator');
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'wlwmanifest_link');
remove_action('wp_head', 'wp_shortlink_wp_head', 10, 0);
remove_action('wp_head', 'feed_links', 2);
remove_action('wp_head', 'feed_links_extra', 3);
remove_action('wp_head', 'start_post_rel_link', 10, 0);
remove_action('wp_head', 'parent_post_rel_link', 10, 0);
remove_action('wp_head', 'index_rel_link');
remove_action('wp_head', 'adjacent_posts_rel_link', 10, 0);
remove_action('wp_head', 'adjacent_posts_rel_link_wp_head, 10, 0');

//* Disable Gutenberg stylesheet in front
function tcwp_deregister_styles() {
    wp_dequeue_style( 'wp-block-library' );
    wp_dequeue_style( 'wp-block-library-theme' );
    wp_dequeue_style( 'wc-blocks-vendors-style' );
    wp_dequeue_style( 'wc-all-blocks-style' );
}
add_action( 'wp_print_styles', 'tcwp_deregister_styles', 100 );

//* Loại bỏ Query String trong WordPress
function remove_cssjs_ver( $src ) {
 if( strpos( $src, '?ver=' ) )
 $src = remove_query_arg( 'ver', $src );
 return $src;
}
add_filter( 'style_loader_src', 'remove_cssjs_ver', 10, 2 );
add_filter( 'script_loader_src', 'remove_cssjs_ver', 10, 2 );


//* Remove WP Embed Script
function stop_loading_wp_embed() {
if (!is_admin()) {
wp_deregister_script('wp-embed');
}
}
add_action('init', 'stop_loading_wp_embed');


// xoa phien ban wp khoi css va js
function remove_css_js_version( $src ) {
if( strpos( $src, '?ver=' ) )
$src = remove_query_arg( 'ver', $src );
return $src;
}
add_filter( 'style_loader_src', 'remove_css_js_version', 9999 );
add_filter( 'script_loader_src', 'remove_css_js_version', 9999 );

/*
* Xoá bỏ link feed rss trong WordPress
*/
function wp_disable_feeds() {
    wp_safe_redirect(home_url(), 301);
    die();
}
   
add_action('do_feed', 'wp_disable_feeds', 1);
add_action('do_feed_rdf', 'wp_disable_feeds', 1);
add_action('do_feed_rss', 'wp_disable_feeds', 1);
add_action('do_feed_rss2', 'wp_disable_feeds', 1);
add_action('do_feed_atom', 'wp_disable_feeds', 1);
add_action('do_feed_rss2_comments', 'wp_disable_feeds', 1);
add_action('do_feed_atom_comments', 'wp_disable_feeds', 1);
remove_action('wp_head', 'feed_links', 2 );
remove_action('wp_head', 'feed_links_extra', 3 );

// xoa phien ban wp tu head va rss
function artisansweb_remove_version() {
return '';
}
add_filter('the_generator', 'artisansweb_remove_version');

//Remove JQuery migrate
function remove_jquery_migrate( $scripts ) {
   if ( ! is_admin() && isset( $scripts->registered['jquery'] ) ) {
        $script = $scripts->registered['jquery'];
   if ( $script->deps ) { 
// Check whether the script has any dependencies
        $script->deps = array_diff( $script->deps, array( 'jquery-migrate' ) );
 }
 }
 }
add_action( 'wp_default_scripts', 'remove_jquery_migrate' );

// xoa file class theme. style
add_action('wp_enqueue_scripts','tcwp_disable_classic_theme_styles', 100);
function tcwp_disable_classic_theme_styles(){
wp_deregister_style('classic-theme-styles');
wp_dequeue_style('classic-theme-styles');
}
// Tăng tốc độ tìm kiếm
add_filter('posts_search','tcwp_search_by_title_only', 500, 2);
function tcwp_search_by_title_only( $search, $wp_query )
	{
		global $wpdb;
		if ( empty( $search ) )
			return $search;
		$q = $wp_query->query_vars;    
		$n = ! empty( $q['exact'] ) ? '' : '%';

		$search =
			$searchand = '';

		foreach ( (array) $q['search_terms'] as $term ) {
			$term = esc_sql( like_escape( $term ) );
			$search .= "{$searchand}($wpdb->posts.post_title LIKE '{$n}{$term}{$n}')";
			$searchand = ' AND ';
		}

		if ( ! empty( $search ) ) {
			$search = " AND ({$search}) ";
			if ( ! is_user_logged_in() )
				$search .= " AND ($wpdb->posts.post_password = '') ";
		}

		return $search;
}

// ẩn version wp
function wpb_remove_version() {
return '';
}
add_filter('the_generator', 'wpb_remove_version');

/* xoa css block WordPress khong su dung */
// Fully Disable Gutenberg editor.
add_filter('use_block_editor_for_post_type', '__return_false', 10);
// Don't load Gutenberg-related stylesheets.
add_action('wp_enqueue_scripts', 'remove_block_css', 100);
function remove_block_css()
{
    wp_dequeue_style('wp-block-library'); // WordPress core
    wp_dequeue_style('wp-block-library-theme'); // WordPress core
    wp_dequeue_style('wc-block-style'); // WooCommerce
}

// Xóa các tab không cần trong checkout
add_filter('woocommerce_checkout_fields', 'dms_custom_override_checkout_fields', 9999999);
function dms_custom_override_checkout_fields($fields)
{
    //billing
    $fields['billing']['billing_first_name'] = array(
        'label' => __('Họ và tên', 'tcwp'),
        'placeholder' => _x('Họ và tên', 'placeholder', 'tcwp'),
        'required' => true,
        'class' => array('form-row-first'),
        'clear' => true,
        'priority' => 10
    );
    unset($fields['billing']['billing_last_name']);
    unset($fields['billing']['billing_company']);
    unset($fields['billing']['billing_country']);
    unset($fields['billing']['billing_postcode']);
    unset($fields['billing']['billing_state']);
    unset($fields['billing']['billing_city']);
	unset($fields['billing']['billing_address_1']);
    unset($fields['billing']['billing_address_2']);
    $fields['billing']['billing_phone']['priority'] = 20;
    $fields['billing']['billing_phone']['class'] = array('form-row-last');
    $fields['billing']['billing_phone']['placeholder'] = _x('Số điện thoại', 'placeholder', 'tcwp');
    $fields['billing']['billing_address_1']['class'] = array('form-row-wide');
    $fields['billing']['billing_address_1']['priority'] = 22;
 
    $fields['billing']['billing_email']['priority'] = 25;
    $fields['billing']['billing_email']['class'] = array('form-row-wide');
    $fields['billing']['billing_email']['required'] = false;
    //shipping
    $fields['shipping']['shipping_first_name'] = array(
        'label' => __('Họ và tên', 'tcwp'),
        'placeholder' => _x('Họ và tên', 'placeholder', 'tcwp'),
        'required' => true,
        'class' => array('form-row-first'),
        'clear' => true,
        'priority' => 10
    );
    unset($fields['shipping']['shipping_last_name']);
    unset($fields['shipping']['shipping_company']);
    unset($fields['shipping']['shipping_country']);
    unset($fields['shipping']['shipping_state']);
    unset($fields['shipping']['shipping_postcode']);
    unset($fields['shipping']['shipping_city']);
	unset($fields['billing']['billing_address_1']);
    unset($fields['shipping']['shipping_address_2']);
    $fields['shipping']['shipping_address_1']['class'] = array('form-row-wide');
    $fields['shipping']['shipping_phone'] = array(
        'label' => __('Số điện thoại', 'tcwp'),
        'placeholder' => _x('Số điện thoại', 'placeholder', 'tcwp'),
        'required' => true,
        'class' => array('form-row-last'),
        'clear' => true,
        'priority'  =>  20
    );
    uasort($fields['billing'], 'dms_sort_fields_by_order');
    uasort($fields['shipping'], 'dms_sort_fields_by_order');
    return $fields;
}
if(!function_exists('dms_sort_fields_by_order')) {
    function dms_sort_fields_by_order($a, $b)
    {
        if (!isset($b['priority']) || !isset($a['priority']) || $a['priority'] == $b['priority']) {
            return 0;
        }
        return ($a['priority'] < $b['priority']) ? -1 : 1;
    }
}
 
add_action( 'woocommerce_admin_order_data_after_shipping_address', 'my_custom_checkout_field_display_admin_order_meta', 10, 1 );
function my_custom_checkout_field_display_admin_order_meta($order){
    echo '<p><strong>'.__('Số ĐT người nhận').':</strong> <br>' . get_post_meta( $order->id, '_shipping_phone', true ) . '</p>';
}
/**
 * Rename product data tabs
 */
add_filter( 'woocommerce_product_tabs', 'woo_rename_tabs', 98 );
function woo_rename_tabs( $tabs ) {

	$tabs['description']['title'] = __( 'Thông Tin Sản Phẩm' );		// Thay đổi tên tab description
	return $tabs;

}

//Tạo shorcode bài viết liên quan trong sidebar
function nbw_bvlq() {
$categories = get_the_category(get_the_ID());
if ($categories){
    echo '<div class="flatsome_recent_posts">';
    $category_ids = array();
    foreach($categories as $individual_category) $category_ids[] = $individual_category->term_id;
    $args=array(
        'category__in' => $category_ids,
        'post__not_in' => array(get_the_ID()),
        'posts_per_page' => 5, // So bai viet dc hien thi
    );
    $my_query = new wp_query($args);
    if( $my_query->have_posts() ):
        echo '<span class="widget-title "><span>Bài Viết Liên Quan:</span></span>
        <ul>';
        while ($my_query->have_posts()):$my_query->the_post();
            ?>
            <li class="recent-blog-posts-li">
                <div class="flex-row recent-blog-posts align-top pt-half pb-half">
                <div class="flex-col mr-half">
					<div class="badge post-date  badge-outline">
                <div class="badge-inner">
                <?php the_post_thumbnail('full'); ?>
                                							</div>
					</div>
				</div>
                <div class="flex-col flex-grow">
					  <a href="<?php the_permalink() ?>"><?php the_title(); ?></a>
				</div>
			</div>          
       
            </li>
            <?php
        endwhile;
        echo '</ul>';
    endif; wp_reset_query();
    echo '</div>';
}}
add_shortcode( 'bvlq', 'nbw_bvlq' );

/*
* Đoạn code thu gọn nội dung bao gồm cả nút xem thêm và thu gọn lại sau khi đã click vào xem thêm
*/
add_action('wp_footer','devvn_readmore_flatsome');
function devvn_readmore_flatsome(){
?>
<style>
  .single-product div#tab-description {
    overflow: hidden;
    position: relative;
    padding-bottom: 25px;
  }

  .fix_height {
    max-height: 500px;
    overflow: hidden;
    position: relative;
  }

  .single-product .tab-panels div#tab-description.panel:not(.active) {
    height: 0 !important;
  }

  .devvn_readmore_flatsome {
    text-align: center;
    cursor: pointer;
    position: absolute;
    z-index: 10;
    bottom: 0;
    width: 100%;
    background: #fff;
  }

  .devvn_readmore_flatsome:before {
    height: 55px;
    margin-top: -45px;
    content: "";
    background: -moz-linear-gradient(top, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, 1) 100%);
    background: -webkit-linear-gradient(top, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, 1) 100%);
    background: linear-gradient(to bottom, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, 1) 100%);
    filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#ffffff00', endColorstr='#ffffff', GradientType=0);
    display: block;
  }

  .devvn_readmore_flatsome a {
    color: #318A00;
    display: block;
  }

  .devvn_readmore_flatsome a:after {
    content: '';
    width: 0;
    right: 0;
    border-top: 6px solid #318A00;
    border-left: 6px solid transparent;
    border-right: 6px solid transparent;
    display: inline-block;
    vertical-align: middle;
    margin: -2px 0 0 5px;
  }

  .devvn_readmore_flatsome_less a:after {
    border-top: 0;
    border-left: 6px solid transparent;
    border-right: 6px solid transparent;
    border-bottom: 6px solid #318A00;
  }

  .devvn_readmore_flatsome_less:before {
    display: none;
  }
</style>
<script>
  (function ($) {
    $(window).on('load', function () {
      if ($('.single-product div#tab-description').length > 0) {
        let wrap = $('.single-product div#tab-description');
        let current_height = wrap.height();
        let your_height = 500;
        if (current_height > your_height) {
          wrap.addClass('fix_height');
          wrap.append(function () {
            return '<div class="devvn_readmore_flatsome devvn_readmore_flatsome_more"><a title="Xem thêm" href="javascript:void(0);">Xem thêm</a></div>';
          });
          wrap.append(function () {
            return '<div class="devvn_readmore_flatsome devvn_readmore_flatsome_less" style="display: none;"><a title="Xem thêm" href="javascript:void(0);">Thu gọn</a></div>';
          });
          $('body').on('click', '.devvn_readmore_flatsome_more', function () {
            wrap.removeClass('fix_height');
            $('body .devvn_readmore_flatsome_more').hide();
            $('body .devvn_readmore_flatsome_less').show();
          });
          $('body').on('click', '.devvn_readmore_flatsome_less', function () {
            wrap.addClass('fix_height');
            $('body .devvn_readmore_flatsome_less').hide();
            $('body .devvn_readmore_flatsome_more').show();
          });
        }
      }
    });
  })(jQuery);
</script>
<?php
}
/*
* Thu gọn mô tả dmsp
*/
add_action('wp_footer','readmore_flatsome');
function readmore_flatsome(){
?>
<style>
  .category-page-row .term-description {
    overflow: hidden;
    position: relative;
    padding-bottom: 25px;
  }

  .fix_height {
    max-height: 500px;
    overflow: hidden;
    position: relative;
  }

  .readmore_flatsome {
    text-align: center;
    cursor: pointer;
    position: absolute;
    z-index: 10;
    bottom: 0;
    width: 100%;
    background: #fff;
  }

  .readmore_flatsome:before {
    height: 55px;
    margin-top: -45px;
    content: "";
    background: -moz-linear-gradient(top, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, 1) 100%);
    background: -webkit-linear-gradient(top, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, 1) 100%);
    background: linear-gradient(to bottom, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, 1) 100%);
    filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#ffffff00', endColorstr='#ffffff', GradientType=0);
    display: block;
  }

  .readmore_flatsome a {
    color: #318A00;
    display: block;
  }

  .readmore_flatsome a:after {
    content: '';
    width: 0;
    right: 0;
    border-top: 6px solid #318A00;
    border-left: 6px solid transparent;
    border-right: 6px solid transparent;
    display: inline-block;
    vertical-align: middle;
    margin: -2px 0 0 5px;
  }

  .readmore_flatsome_less a:after {
    border-top: 0;
    border-left: 6px solid transparent;
    border-right: 6px solid transparent;
    border-bottom: 6px solid #318A00;
  }

  .readmore_flatsome_less:before {
    display: none;
  }
</style>
<script>
  (function ($) {
    $(window).on('load', function () {
      if ($('.category-page-row .term-description').length > 0) {
        let wrap = $('.category-page-row .term-description');
        let current_height = wrap.height();
        let your_height = 500;
        if (current_height > your_height) {
          wrap.addClass('fix_height');
          wrap.append(function () {
            return '<div class="readmore_flatsome readmore_flatsome_more"><a title="Xem thêm" href="javascript:void(0);">Xem thêm</a></div>';
          });
          wrap.append(function () {
            return '<div class="readmore_flatsome readmore_flatsome_less" style="display: none;"><a title="Xem thêm" href="javascript:void(0);">Thu gọn</a></div>';
          });
          $('body').on('click', '.readmore_flatsome_more', function () {
            wrap.removeClass('fix_height');
            $('body .readmore_flatsome_more').hide();
            $('body .readmore_flatsome_less').show();
          });
          $('body').on('click', '.readmore_flatsome_less', function () {
            wrap.addClass('fix_height');
            $('body .readmore_flatsome_less').hide();
            $('body .readmore_flatsome_more').show();
          });
        }
      }
    });
  })(jQuery);
</script>
<?php
}
// move mô tả dmsp
add_action( 'wp', 'tcwp_move_wc_archive_description' );
function tcwp_move_wc_archive_description() {
    if ( is_archive() ) {
        remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10 );
        remove_action( 'woocommerce_archive_description', 'woocommerce_product_archive_description', 10 );
        add_action( 'woocommerce_after_main_content', 'woocommerce_taxonomy_archive_description', 10 );
        add_action( 'woocommerce_after_main_content', 'woocommerce_product_archive_description', 10 );
    }
}
